// Ievades apstrāde
getControls();

// X kustība, ja spēlētājs atrodas uz zemes un neveic uzlādi
if (onGround && !isChargingJump) {
    moveDir = rightkey - leftkey; // Kustības virziena noteikšana
    if (moveDir != 0) {
        face = moveDir; // Iestatīt skatīšanās virzienu
    }
    xspd = moveDir * moveSpd; // Aprēķināt horizontālo ātrumu
} else if (isChargingJump) {
    jumpDirection = rightkey - leftkey; // Uzlādes laikā saglabā lēciena virzienu
    xspd = 0; // Lēciens uz vietas

    // Uzlādes laikā atjaunina skatīšanās virzienu
    if (jumpDirection != 0) {
        face = jumpDirection; // Iestatīt skatīšanās virzienu uzlādes laikā
    }
}

// Pielietot X ātrumu, ja atrodas uz zemes (ar sadursmju pārbaudi)
if (onGround) {
    if (!place_meeting(x + xspd, y, oWall)) {
        x += xspd; // Pārvieto spēlētāju horizontāli
    } else {
        xspd = 0; // Bloķē kustību pie sienas
    }
}

// Y kustība (lēkšana un gravitācija)
if (onGround) {
    if (jumpKey) {
        isChargingJump = true; // Sāk lēciena uzlādi
        jumpCharge += 1; // Palielina uzlādes vērtību
        if (jumpCharge > maxJumpCharge) jumpCharge = maxJumpCharge; // Ierobežo maksimālo uzlādi
        show_debug_message("Uzlādes lēciens: " + string(jumpCharge));
    }

    if ((!jumpKey && isChargingJump) || jumpCharge == maxJumpCharge) {
        if (jumpCharge >= minJumpCharge) {
            yspd = lerp(global.jspd[1], global.jspd[0], (jumpCharge - minJumpCharge) / (maxJumpCharge - minJumpCharge)); // Aprēķina lēciena ātrumu
            jumpSpeed = jumpDirection * (moveSpd + 2); // Aprēķina horizontālo ātrumu lēciena laikā
            xspd = jumpSpeed;
            onGround = false; // Atstāj zemi
        }
        isChargingJump = false; // Beidz uzlādi
        jumpCharge = 0; // Atiestata uzlādes vērtību
    }
} else {
    yspd += grav; // Pielieto gravitāciju
}

// Sienas atsitiena loģika (gaisā saduroties ar sienām)
if (!onGround && place_meeting(x + xspd, y, oWall)) {
    xspd = -xspd * 0.4; // Maina horizontālā ātruma virzienu un to samazina
    yspd = yspd * 1;    // Saglabā vertikālo ātrumu
    show_debug_message("Sienas atsitiens! xspd: " + string(xspd) + ", yspd: " + string(yspd));

    var _pixelCheck = sign(xspd) * -1; // Veic precīzu pikseļu pārbaudi
    while (place_meeting(x + _pixelCheck, y, oWall)) {
        x -= _pixelCheck;
    }
}

// Ierobežo krišanas ātrumu (terminālais ātrums)
if (yspd > termVel) {
    yspd = termVel;
}

// Y sadursmes pārbaude (vertikālā kustība)
if (place_meeting(x, y + yspd, oWall)) {
    var _pixelCheck = sign(yspd) * 0.5; // Pārbaude nelieliem soļiem
    while (!place_meeting(x, y + _pixelCheck, oWall)) {
        y += _pixelCheck; // Kustība precīzā līmenī
    }

    if (yspd < 0) {
        jumpHoldTimer = 0; // Atiestata lēciena taimeri
    }
    yspd = 0; // Apstādina vertikālo kustību
}

// Pielieto X un Y ātrumus
x += xspd;
y += yspd;

// Zemes pārbaude
if (place_meeting(x, y + 1, oWall) && !place_meeting(x, y, oWall)) {
    onGround = true; // Spēlētājs atrodas uz zemes
} else {
    onGround = false; // Spēlētājs ir gaisā
}

// Spēlētāja sprite kontrole
if (isChargingJump) {
    sprite_index = chargeSpr; // Uzlādes sprite
} else if (abs(xspd) > 0 && !isChargingJump) {
    sprite_index = walkSpr; // Kustības sprite
} else if (xspd == 0 && !isChargingJump) {
    sprite_index = idleSpr; // Stāvēšanas sprite
} else if (!onGround) {
    sprite_index = jumpSpr; // Lēciena sprite
}

// Iestata sadursmju masku
mask_index = maskSpr;
